<?php
// Desactivar la visualización de errores en producción para mayor seguridad
// error_reporting(0); 

// --- Configuración del Correo ---
$to = 'giyuutomioka22yte@gmail.com'; // **TU CORREO DE DESTINO (ACTUALIZAR CON EL DEL CLIENTE FINAL)**
$subject = 'Nueva Solicitud de Reserva de Limpieza'; // Asunto del correo

// Se asume que el servidor puede enviar correos (muchos hosting requieren un 'From' válido)
$headers = "From: webmaster@tudominio.com\r\n"; // Reemplaza 'tudominio.com' por tu dominio real
$headers .= "Reply-To: giyuutomioka22yte@gmail.com\r\n"; // Puede ser útil para responder
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";

// --- Recolección de Datos del Formulario ---
// Usamos $_POST para obtener los datos enviados por el formulario
$firstName = isset($_POST['firstName']) ? htmlspecialchars($_POST['firstName']) : 'No proporcionado';
$lastName = isset($_POST['lastName']) ? htmlspecialchars($_POST['lastName']) : 'No proporcionado';
$email = isset($_POST['email']) ? htmlspecialchars($_POST['email']) : 'No proporcionado';
$phone = isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : 'No proporcionado';
$smsReminder = isset($_POST['smsReminder']) ? 'Sí' : 'No'; // Checkbox
$address = isset($_POST['address']) ? htmlspecialchars($_POST['address']) : 'No proporcionada';
$aptSuite = isset($_POST['aptSuite']) ? htmlspecialchars($_POST['aptSuite']) : 'No proporcionado';
$zipCode = isset($_POST['zipCode']) ? htmlspecialchars($_POST['zipCode']) : 'No proporcionado';
$state = isset($_POST['state']) ? htmlspecialchars($_POST['state']) : 'No seleccionado'; // Ciudad/Estado
$serviceType = isset($_POST['serviceType']) ? htmlspecialchars($_POST['serviceType']) : 'No seleccionado';
$squareFeet = isset($_POST['squareFeet']) ? htmlspecialchars($_POST['squareFeet']) : 'No seleccionado';
$frequency = isset($_POST['frequency']) ? htmlspecialchars($_POST['frequency']) : 'No seleccionada';
$paymentMethod = isset($_POST['payment_method']) ? htmlspecialchars($_POST['payment_method']) : 'No seleccionado';

// Recoger los extras seleccionados (el campo 'extras[]' es un array en HTML)
$extras = 'Ninguno';
if (isset($_POST['extras']) && is_array($_POST['extras'])) {
    $extras = implode(", ", $_POST['extras']); // Convierte el array en una lista separada por comas
}

// **Nota:** No se incluye el código de descuento o el resultado del cálculo del precio aquí, ya que el cálculo se realiza en JavaScript (lado del cliente). Idealmente, el precio final debe ser calculado y enviado desde el JS en un campo oculto, o recalculado en el servidor para mayor seguridad.
// Por ahora, enviaremos todos los campos disponibles.

// --- Estructura del Mensaje (HTML para un formato más bonito) ---
$message = '
<html>
<head>
    <title>Nueva Reserva</title>
</head>
<body>
    <h2>Detalles de la Nueva Reserva de Limpieza</h2>
    <table border="1" style="width:100%; border-collapse: collapse;">
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Nombre:</strong></td><td style="padding: 10px;">' . $firstName . ' ' . $lastName . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Correo Electrónico:</strong></td><td style="padding: 10px;">' . $email . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Teléfono:</strong></td><td style="padding: 10px;">' . $phone . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Recordatorio SMS:</strong></td><td style="padding: 10px;">' . $smsReminder . '</td></tr>
        <tr><td colspan="2" style="background-color: #ccc; text-align: center; padding: 5px;"><strong>DETALLES DEL SERVICIO</strong></td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Dirección:</strong></td><td style="padding: 10px;">' . $address . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Apt/Suite:</strong></td><td style="padding: 10px;">' . $aptSuite . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Código Postal:</strong></td><td style="padding: 10px;">' . $zipCode . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Ubicación/Estado:</strong></td><td style="padding: 10px;">' . $state . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Tipo de Servicio:</strong></td><td style="padding: 10px;">' . $serviceType . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Tamaño (Sq. Ft.):</strong></td><td style="padding: 10px;">' . $squareFeet . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Frecuencia:</strong></td><td style="padding: 10px;">' . $frequency . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Extras Seleccionados:</strong></td><td style="padding: 10px;">' . $extras . '</td></tr>
        <tr><td style="padding: 10px; background-color: #f2f2f2;"><strong>Método de Pago:</strong></td><td style="padding: 10px;">' . $paymentMethod . '</td></tr>
    </table>
    <p>¡No olvides revisar tu calendario de Google para la cita programada!</p>
</body>
</html>
';

// --- Enviar Correo y Redirigir ---
if (mail($to, $subject, $message, $headers)) {
    // Éxito: Redirige al usuario a una página de agradecimiento
    header('Location: thanks.html'); 
    exit;
} else {
    // Error: Redirige a una página de error o muestra un mensaje
    // Para simplificar, redirigiremos con un parámetro de error
    header('Location: index.html?status=error'); 
    exit;
}
?>