document.addEventListener('DOMContentLoaded', () => {
    // 1. Elementos del Formulario
    const form = document.getElementById('bookingForm');
    const stepContents = document.querySelectorAll('.step-content');
    const progressSteps = document.querySelectorAll('.step');
    const nextButtons = document.querySelectorAll('.next-btn');
    const prevButtons = document.querySelectorAll('.cssbuttons-io-button-left');
    const frequencyButtons = document.querySelectorAll('.frequency-options .selection-button');
    const extrasContainer = document.getElementById('extrasContainer');
    let currentStep = 1;
    let discountRate = 0; // Variable para el descuento por código

    // --- Lógica de Navegación ---
    
    function showStep(stepNumber) {
        // Ocultar todos los pasos
        stepContents.forEach(content => {
            content.classList.remove('active');
        });

        // Mostrar el paso deseado
        const targetStep = document.getElementById(`step-${stepNumber}`);
        if (targetStep) {
            targetStep.classList.add('active');
        }

        // Actualizar la barra de progreso
        progressSteps.forEach(step => {
            const stepNum = parseInt(step.getAttribute('data-step'));
            if (stepNum <= stepNumber) {
                step.classList.add('active');
            } else {
                step.classList.remove('active');
            }
        });
        currentStep = stepNumber;
    }

    function validateCurrentStep(step) {
        // En una aplicación real, aquí validarías que los campos requeridos estén llenos.
        // Ejemplo para el Paso 1:
        if (step === 1) {
             const firstName = document.getElementById('firstName').value;
             const email = document.getElementById('email').value;
             if (!firstName || !email) {
                 alert('Por favor, rellena los campos de contacto requeridos.');
                 return false;
             }
        }
        // Para este ejercicio, asumimos que todos los pasos intermedios son válidos.
        return true;
    }

    // Inicializar y Manejar Navegación
    showStep(currentStep);

    nextButtons.forEach(button => {
        button.addEventListener('click', () => {
            if (validateCurrentStep(currentStep)) {
                const nextStep = parseInt(button.getAttribute('data-next-step'));
                showStep(nextStep);
            }
        });
    });

    prevButtons.forEach(button => {
        button.addEventListener('click', () => {
            const prevStep = parseInt(button.getAttribute('data-prev-step'));
            showStep(prevStep);
        });
    });

    // --- Lógica de Interacción de Pasos 3 y 4 ---

    // 1. Manejar la selección de Frecuencia (Paso 3)
    frequencyButtons.forEach(button => {
        button.addEventListener('click', () => {
            // Desactivar todos y activar el seleccionado
            frequencyButtons.forEach(b => b.classList.remove('active'));
            button.classList.add('active');
            // Actualizar el campo oculto
            document.getElementById('frequency').value = button.getAttribute('data-value');
        });
    });
    
    // 2. Manejar la selección de Extras (Paso 4)
    extrasContainer.addEventListener('click', (event) => {
        const item = event.target.closest('.extra-item');
        if (item) {
            item.classList.toggle('active');
        }
    });

    // 3. Manejar el Botón de Aplicar Descuento (Paso 4)
    document.getElementById('applyDiscountBtn').addEventListener('click', () => {
        const code = document.getElementById('discountCode').value.trim().toUpperCase();
        if (code === 'SAVE20') { 
            discountRate = 0.20; // 20% de descuento
            alert('¡Código de descuento aplicado! (20%)');
        } else {
            discountRate = 0;
            alert('Código de descuento no válido. Descuento eliminado.');
        }
    });
    
    // --- Lógica de Cálculo de Fondos (Paso 5) ---
    
    window.calculateFinalFunds = function() {
        // A. Definición de costos y descuentos
        const sizePrices = {
            '700': 115.00, // Precio base para 700-800 Sq Ft
            '800': 125.00,
            '900': 135.00,
            '1000': 145.00,
            // ... más precios ...
        };
        
        const frequencyDiscounts = {
            'OneTime': 0.00, 
            'Monthly': 0.28, 
            'Biweekly': 0.35,
            'Weekly': 0.40,
            'Every3Weeks': 0.30
        };

        const salesTaxRate = 0.0636; // 6.36%

        // B. Obtener valores del formulario
        const selectedSize = document.getElementById('squareFeet').value; 
        const selectedFrequency = document.getElementById('frequency').value;
        
        // C. 1. Calcular Costo Base
        let baseCost = sizePrices[selectedSize] || 0; 
        
        // C. 2. Calcular Costo de Extras
        let extrasTotal = 0;
        document.querySelectorAll('.extra-item.active').forEach(item => {
            extrasTotal += parseFloat(item.getAttribute('data-price'));
        });
        
        // C. 3. Subtotal con Extras
        let finalSubtotal = baseCost + extrasTotal;
        
        // D. Aplicar Descuento por Frecuencia
        const frequencyDiscountRate = frequencyDiscounts[selectedFrequency] || 0;
        const frequencyDiscountAmount = finalSubtotal * frequencyDiscountRate;
        
        // E. Aplicar Descuento de Código
        const codeDiscountAmount = finalSubtotal * discountRate;
        
        // Total de Descuento
        const totalDiscount = frequencyDiscountAmount + codeDiscountAmount; 
        
        // F. Calcular Subtotal Después de Descuentos
        const afterDiscount = finalSubtotal - totalDiscount;
        
        // G. Aplicar Impuesto
        const salesTax = afterDiscount * salesTaxRate;

        // H. Calcular Total Final
        const finalTotal = afterDiscount + salesTax;
        
        // I. Mostrar el resultado en el Paso 5
        const resultElement = document.getElementById('calculationResult');
        resultElement.innerHTML = `
            <div class="summary-line"><span><i class="fa fa-home"></i> (${selectedSize}-X Square Feet)</span> <span>$${baseCost.toFixed(2)}</span></div>
            <div class="summary-line"><span>Costo de Extras</span> <span>$${extrasTotal.toFixed(2)}</span></div>
            <hr style="border: 0; border-top: 1px solid #ccc;">
            <div class="summary-line"><span>SUB-TOTAL</span> <span>$${finalSubtotal.toFixed(2)}</span></div>
            <div class="summary-line"><span>DISCOUNT (Total)</span> <span>-$${totalDiscount.toFixed(2)}</span></div>
            <div class="summary-line"><span>SALES TAX (${(salesTaxRate * 100).toFixed(2)}%)</span> <span>$${salesTax.toFixed(2)}</span></div>
            <div class="summary-line summary-total"><span>TOTAL</span> <span>$${finalTotal.toFixed(2)}</span></div>
        `;
    }
});


const openCalendar = document.getElementById('openCalendar');
const closeCalendar = document.getElementById('closeCalendar');
const calendarModal = document.getElementById('calendarModal');

openCalendar.addEventListener('click', () => {
  calendarModal.style.display = 'flex';
});

closeCalendar.addEventListener('click', () => {
  calendarModal.style.display = 'none';
});

window.addEventListener('click', (e) => {
  if (e.target === calendarModal) {
    calendarModal.style.display = 'none';
  }
});



function toggleExtra(item) {
    const checkbox = item.querySelector('input[type="checkbox"]');
    checkbox.checked = !checkbox.checked;
    item.classList.toggle('selected', checkbox.checked);
}



